/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.justverticalslabs.recipes;

import com.google.gson.JsonObject;
import crystalspider.justverticalslabs.utils.VerticalSlabUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public interface VerticalSlabRecipe<C extends Container>
extends Recipe<C> {
    public ItemStack m_5874_(C var1);

    public boolean m_5818_(C var1, Level var2);

    public Serializer<C, ? extends VerticalSlabRecipe<C>> getSerializer();

    default public boolean m_5598_() {
        return true;
    }

    default public boolean isVerticalSlab(ItemStack itemStack) {
        BlockState referredSlabState = VerticalSlabUtils.getReferredSlabState(itemStack);
        return !itemStack.m_41619_() && referredSlabState != null && VerticalSlabUtils.MapsManager.slabStateMap.containsKey((Object)referredSlabState.m_60734_().m_5456_());
    }

    public static abstract class Serializer<C extends Container, T extends VerticalSlabRecipe<C>>
    implements RecipeSerializer<T> {
        private final Supplier<T> recipeSupplier;

        protected Serializer(Supplier<T> recipeSupplier) {
            this.recipeSupplier = recipeSupplier;
        }

        public final T fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            return (T)((VerticalSlabRecipe)this.recipeSupplier.get());
        }

        public final T fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            return (T)((VerticalSlabRecipe)this.recipeSupplier.get());
        }

        public final void toNetwork(FriendlyByteBuf friendlyByteBuf, T verticalSlabRecipe) {
        }
    }
}

